#include "mc96f8316.h"
#include "intrins.h"
#include "define.h"

sbit wei_1=P0^5;
sbit wei_2=P0^4;
sbit wei_3=P0^3;
sbit wei_4=P0^2;

uchar p2_reg=0xff;
uchar debounce10ms_cnt=0;
uchar userflag=0;
uchar mode=0xd1,mode_offset=0;
uchar vol=0xed;
uchar music_no=1,temp,dis_flag=0;

code uchar duan_table[]={0xc0,0xf9,0xa4,0xb0,0x99,0x92,0x82,0xf8,0x80,0x90,0x88,0x83,0xc6,0xa1,0x86,0x8e};

void port_init();
void inter_init();
void key_scan();
void display();
void send_line(uchar addr_l);
void  Delay(unsigned int time);

void main()
{
	inter_init();
	port_init();
	music_no=1;
	while(1)
	{
		key_scan();
		display();
	}	
}

void port_init()
{
	P0IO    = 0xff;         // -      out
    P0OD    = 0x00;         
	P0PU    = 0xff;         // -      on     on     on     on     off    on     on
 	P0		= 0xFF;		    // -      1      1      1      1      1      1      1
 	P0FSR   = 0x00;

	P1IO    = 0xff;         // out    out    out    out    out    out    out    out
    P1OD    = 0x00;         // PP     PP     PP     PP     PP     PP     PP     PP
	P1PU    = 0xff;         // off    off    off    off    off    off    off    off
 	P1		= 0xff;		    // 0      0      0      0      0      0      1      0
 	P1FSRH  = 0x00;		    // 0      0      0      0      0      0      0      0
 	P1FSRL  = 0x00;	

	P2IO    = 0x00;         // -      out    out    out    out    out    out    out
    P2OD    = 0x00;         // -      OD     OD     OD     OD     OD     OD     OD
	P2PU    = 0xFF;         // -      off    on     on     off    off    off    off
 	P2		= 0xFF;		    // -      1      1      1      1      1      1      1
 	P2FSR   = 0x00;

	P3IO    = 0x0a;         // in     in     out    in     in     out    in     in
    P3OD    = 0x04;			//P3OD    = 0x07;         // PP     PP     PP     PP     PP     PP     OD     OD				
	P3PU    = 0xff;         // off    off    off    off    off    off    on     on
 	P3		= 0xff;		    // 0      0      0      0      0      0      1      1
 	P3FSR   = 0x00;	
}

//---------ʱ0жϳʼ--------//
void inter_init()			 
{
//ڲ		
	SCCR=0x00;			//ڲ𵴵·	
	OSCCR=0x20;			//ѡ8M ڲ𵴵·ʹ 

//ʱ
	T0DR=100;		//˶ʱ100Us
	T0CR=0x84;		//ڲʱӽ8Ƶ  8M/8=1M
	IE=0x80;		//ж
	IE1=0x18;
	IE2=0x02;		//timer0ж
	IE3=0x00;
}

void timer0() interrupt 13
{
	debounce10ms_cnt++;
	if(debounce10ms_cnt>=10)
	{
		debounce10ms_cnt=0;
		userflag|=_10ms_flag;
	}
}

void key_scan()
{
  uchar a,b;
	if(userflag&_10ms_flag)
	{
		userflag&=~_10ms_flag;
		a=P2&0x7f;
		b=a;   
		a=a^p2_reg;
		a=a&p2_reg;
		p2_reg=b;
		if(a)
		{
		  if(a==0x01)
		  {
		    dis_flag=1;		
			vol++;
			if(vol>=0xf1) vol=0xd2;
		    send_line(vol);
		  }
		  if(a==0x02)
		  {
		    dis_flag=1;
			vol--; 
			if(vol<=0xd1) vol=0xf0;
		    send_line(vol);
		  }
		  if(a==0x04)
		  {
		    dis_flag=0;	
		     music_no++;
			if(music_no>=200)  music_no=1;
		    send_line(music_no);
		  }
		  if(a==0x08)
		  {
		    dis_flag=0;
	  		music_no--;
			if(music_no==0x00)  music_no=200;
		    send_line(music_no);
		  }
		  if(a==0x10)
		  {
		     dis_flag=0;
		    send_line(music_no);
		  }
		  if(a==0x20)
		  {
		    mode_offset++;
			if(mode_offset>2)
			{
			  mode_offset=0;
			}
			if(mode_offset==0)
			{
			 mode=0xd1;
			 send_line(mode);
			}
			if(mode_offset==1)
			{
			 mode=0xf6;
			 send_line(mode);
			}
			if(mode_offset==2)
			{
			 mode=0xf7;
			 send_line(mode);
			}
		  }
		  if(a==0x40)
		  {
		    send_line(0xfc);
			dis_flag=2;
		  }
		}
	}
}

void display()
{
   if(dis_flag==0)
   {
	 temp=music_no;
   }
   if(dis_flag==1)
   {
	 temp=vol;
   }
   if(dis_flag==2)
   {
	 temp=0xfc;
   }
   P0 |=0x04;
   P0 &=~0x38;
   P1 =duan_table[mode/16];
   Delay(500);

   P0 |=0x10;
   P0 &=~0x2c;
   P1 =duan_table[mode%16] & 0x7f;
   Delay(500);

   P0 |=0x08;
   P0 &=~0x34;
   P1 =duan_table[temp/16];
   Delay(500);

   P0 |=0x20;
   P0 &=~0x1c;
   P1 =duan_table[temp%16];
   Delay(500);
   P0 &=~0x3c;
}

void send_line(uchar addr_l) //ӳ
{
  uchar i;
  P3 |= 0x08;
  Delay(200); 
  P3 &=~0x08;
  Delay(1250); //5000US
  for(i=0;i<8;i++)
  {
    P3|=0x08;
    if(addr_l&0x01)
    {
     Delay(600); //2400US
     P3 &=~0x08;
     Delay(200); //800US
    }
    else
    {
     Delay(200);
     P3 &=~0x08;
     Delay(600);
    }
    addr_l>>=1; 
  }
    P3|=0x08;
    Delay(1600);//ݵȴ50ms
}

void  Delay(unsigned int time)
{
    while(time--)
    {
        _nop_();
        _nop_();
        _nop_();
        _nop_();
        _nop_();
    }
}
